package cn.com.duiba.quanyi.center.api.dto.activity.common.detail;

import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonInterfaceConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/14 16:47
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonDetailDto extends ActivityDto {
    
    private static final long serialVersionUID = -5330018227749160796L;

    /**
     * 出奖方式
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeDrawTypeEnum
     */
    private Integer drawType;

    /**
     * 皮肤ID
     */
    private String skinId;

    /**
     * 子活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSubTypeEnum
     */
    private Integer subType;

    /**
     * 用户限制
     */
    private ActivityCommonUserLimitConfDto userLimit;

    /**
     * 领奖开放时间
     */
    private ActivityCommonTimeLimitConfDto timeLimit;

    /**
     * 领奖次数限制
     */
    private ActivityCommonTakeLimitConfDto takeNumLimit;

    /**
     * 白名单配置
     */
    private ActivityCommonWhiteConfDto whiteConf;

    /**
     * 黑名单配置
     */
    private ActivityCommonBlackConfDto blackConf;

    /**
     * 达标配置
     */
    private ActivityCommonReachStandardConfDto reachStandardConf;

    /**
     * 支付配置
     */
    private ActivityCommonPayConfDto payConf;

    /**
     * 报名配置
     */
    private ActivityCommonSignUpConfDto signUpConf;

    /**
     * 是否开启门店配置
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStore;

    /**
     * 公告配置
     */
    private ActivityCommonNoticeConfDto noticeConf;

    /**
     * 界面配置
     */
    private ActivityCommonInterfaceConfDto interfaceConf;
    
    /**
     * 奖品
     */
    private List<ActivityCommonPrizeDetailDto> prizeList;
}
