package cn.com.duiba.quanyi.center.api.remoteservice.insurance.institution;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceInstitutionSearchParam;
import java.util.List;

/**
 * 保司机构
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceInstitutionService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司机构集合
     */
    List<InsuranceInstitutionDto> selectPage(InsuranceInstitutionSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceInstitutionSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司机构
     */
    InsuranceInstitutionDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司机构
     * @return 执行结果
     */
    Long insert(InsuranceInstitutionDto dto);

    /**
     * 更新
     * @param dto 保司机构
     * @return 影响行数
     */
    int update(InsuranceInstitutionDto dto);

    /**
     * 仅更新机构表
     * @param dto
     * @return
     */
    int updateInstitution(InsuranceInstitutionDto dto);

    /**
     * 根据主键列表查询
     * @param ids 主键
     * @return 保司机构
     */
    List<InsuranceInstitutionDto> selectByIds(List<Long> ids);

    /**
     * 根据公司和机构名称批量查询
     * @param companyId 公司id
     * @param institutionNames 机构名称
     * @return
     */
    List<InsuranceInstitutionDto> selectByCompanyInstitutionNames(Long companyId, List<String> institutionNames);

    /**
     * 支持机构名称模糊查询
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司机构集合
     */
    List<InsuranceInstitutionDto> selectPageVague(InsuranceInstitutionSearchParam param);

    /**
     * 支持机构名称模糊查询
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCountVague(InsuranceInstitutionSearchParam param);

}