/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.hutool.core.date.DateUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public enum ActivityPeriodicUnitEnum {
    FOREVER(1, "\u6c38\u4e45"),
    ABSOLUTE(2, "\u7edd\u5bf9\u65f6\u95f4"),
    DAY(3, "\u65e5"),
    WEEK(4, "\u81ea\u7136\u5468"),
    MONTH(5, "\u81ea\u7136\u6708"),
    QUARTER(6, "\u5b63\u5ea6");

    private final Integer code;
    private final String desc;
    private static final Map<Integer, ActivityPeriodicUnitEnum> ENUM_MAP;

    public Pair<Date, Date> getDate(Date now, Date absoluteStartTime, Date absoluteEndTime) {
        switch (this) {
            case FOREVER: {
                return Pair.of(null, null);
            }
            case ABSOLUTE: {
                return Pair.of((Object)absoluteStartTime, (Object)absoluteEndTime);
            }
            case DAY: {
                return Pair.of((Object)DateUtil.beginOfDay((Date)now), (Object)DateUtil.endOfDay((Date)now));
            }
            case WEEK: {
                return Pair.of((Object)DateUtil.beginOfWeek((Date)now), (Object)DateUtil.endOfWeek((Date)now));
            }
            case MONTH: {
                return Pair.of((Object)DateUtil.beginOfMonth((Date)now), (Object)DateUtil.endOfMonth((Date)now));
            }
            case QUARTER: {
                return Pair.of((Object)DateUtil.beginOfQuarter((Date)now), (Object)DateUtil.endOfQuarter((Date)now));
            }
        }
        return null;
    }

    public Pair<Date, Date> getCurrentPeriod() {
        return this.getDate(new Date(), null, null);
    }

    public Pair<Date, Date> getOffsetPeriod(int offset) {
        Date now = new Date();
        switch (this) {
            case DAY: {
                now = DateUtil.offsetDay((Date)now, (int)offset);
                break;
            }
            case WEEK: {
                now = DateUtil.offsetWeek((Date)now, (int)offset);
                break;
            }
            case MONTH: {
                now = DateUtil.offsetMonth((Date)now, (int)offset);
                break;
            }
            case QUARTER: {
                now = DateUtil.offsetMonth((Date)now, (int)(offset * 3));
                break;
            }
        }
        return this.getDate(now, null, null);
    }

    public static List<ActivityPeriodicUnitEnum> getPeriodTakeEnums() {
        return Arrays.asList(DAY, WEEK, MONTH, QUARTER);
    }

    public static ActivityPeriodicUnitEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    private ActivityPeriodicUnitEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ActivityPeriodicUnitEnum.values()).collect(Collectors.toMap(ActivityPeriodicUnitEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

