package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.center.api.enums.api.ApiMainOrderStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * API供给
 * @author lizhi
 * @date 2023/12/4 20:31
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiMultiChoiceOneOrderResult extends ApiBaseResult {
    
    private static final long serialVersionUID = 4372430151952159865L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 主订单号
     */
    private String orderNo;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 券包主订单状态：
     * ● 1：处理中
     * ● 2：全部成功
     * ● 3：全部失败
     * @see ApiMainOrderStatusEnum
     */
    private Integer mainOrderStatus;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 回调通知mq topic
     */
    private String notifyMqTopic;

    /**
     * 同步结果mq topic
     */
    private String syncMqTopic;

    /**
     * 券包子订单数据，json数组格式
     */
    private List<ApiQuerySubOrderResult> subOrderDataList;

    /**
     * 是否同步请求
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer syncReq;

    /**
     * 券包推送类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiPkgPushTypeEnum
     */
    private Integer pkgPushType;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 公众号H5静默授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String oaLink;

    /**
     * 小程序H5唤起授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String mpLink;

    /**
     * 小程序AppID，微信立减金/到零钱链接券时有值
     */
    private String mpAppId;

    /**
     * 小程序Path，微信立减金/到零钱链接券时有值
     */
    private String mpPath;

    /**
     * 支付宝领取链接, 支付宝立减金，链接券时有值
     */
    private String alipayLink;

    /**
     * 失效时间, 时间戳
     */
    private Long expireTime;

    /**
     * 通用直冲类型短链
     */
    private String generalLink;

    /**
     * 最后更新时间, 时间戳
     */
    private Long lastTime;

    /**
     * 有效期起始时间，毫秒数，1970.1.1开始的毫秒数
     * ● 商品为微信立减金/支付宝立减金时，为券的有效起始时间
     */
    private Long beginTime;

    /**
     * 发放时间，时间戳
     */
    private Long grantTime;
}
