package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiBaseResult;
import cn.com.duiba.quanyi.center.api.dto.api.ApiMultiChoiceOneOrderResult;
import cn.com.duiba.quanyi.center.api.dto.api.ApiOrderResult;
import cn.com.duiba.quanyi.center.api.dto.api.ApiSpecResult;
import cn.com.duiba.quanyi.center.api.param.api.ApiCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiOrderPageParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiQueryOrderParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiReturnedOrderParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiSpecQueryParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiUnbindUidParam;

import java.util.Date;
import java.util.List;

/**
 * API供货服务
 * @author lizhi
 * @date 2023/12/20 16:58
 */
@AdvancedFeignClient
public interface RemoteApiMultiChoiceOneSupplyService {

    /**
     * 下单
     *
     * @param param 下单参数
     * @return 下单结果
     */
    ApiMultiChoiceOneOrderResult createOrder(ApiCreateOrderParam param);

    /**
     * 查询订单
     *
     * @param param 查询参数
     * @return 查询结果
     */
    ApiMultiChoiceOneOrderResult queryOrder(ApiQueryOrderParam param);

    /**
     * 商品信息查询
     *
     * @param param 查询参数
     * @return 商品信息
     */
    ApiSpecResult specQuery(ApiSpecQueryParam param);

}
