/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.workflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ApprovalStatusEnum {
    NOT_COMMIT(1, "\u5f85\u63d0\u4ea4", Boolean.FALSE),
    COMMIT_FAIL(2, "\u63d0\u4ea4\u5931\u8d25", Boolean.FALSE),
    RUNNING(3, "\u5ba1\u6838\u4e2d", Boolean.TRUE),
    TERMINATED(4, "\u5df2\u64a4\u56de", Boolean.TRUE),
    REFUSE(5, "\u5df2\u6253\u56de", Boolean.TRUE),
    AGREE(6, "\u5df2\u901a\u8fc7", Boolean.TRUE),
    DELETE(7, "\u5df2\u5220\u9664", Boolean.TRUE);

    private final Integer status;
    private final String desc;
    private final Boolean show;
    private static final Set<Integer> FINAL_STATUS;
    private static final Map<Integer, ApprovalStatusEnum> ENUM_MAP;
    private static final Set<Integer> FINAL_NOT_AGREE_STATUS;
    private static final Set<Integer> CLOSE_STATUS;
    private static final List<Integer> SHOW_LIST_STATUS;

    public static ApprovalStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    public static boolean isFinalStatus(Integer status) {
        if (status == null) {
            return false;
        }
        return FINAL_STATUS.contains(status);
    }

    public static List<Integer> getShowListStatus() {
        return SHOW_LIST_STATUS;
    }

    public static boolean isFinalNotAgree(Integer status) {
        return REFUSE.getStatus().equals(status);
    }

    public static boolean isCloseStatus(Integer status) {
        return CLOSE_STATUS.contains(status);
    }

    private ApprovalStatusEnum(Integer status, String desc, Boolean show) {
        this.status = status;
        this.desc = desc;
        this.show = show;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public Boolean getShow() {
        return this.show;
    }

    static {
        FINAL_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(TERMINATED.getStatus(), REFUSE.getStatus(), AGREE.getStatus(), DELETE.getStatus())));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ApprovalStatusEnum.values()).collect(Collectors.toMap(ApprovalStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
        FINAL_NOT_AGREE_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(REFUSE.getStatus(), DELETE.getStatus())));
        CLOSE_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(TERMINATED.getStatus(), DELETE.getStatus())));
        SHOW_LIST_STATUS = Arrays.stream(ApprovalStatusEnum.values()).filter(ApprovalStatusEnum::getShow).map(ApprovalStatusEnum::getStatus).collect(Collectors.toList());
    }
}

