package cn.com.duiba.quanyi.center.api.enums.workflow;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/10/21 17:32
 */
@AllArgsConstructor
@Getter
public enum WorkflowTypeEnum {
    PROJECT(1, "项目审批", "创建审批流", "项目生效"),
    DEMAND(2, "需求审批", "创建审批流", "需求审批完成"),
    INVOICE_APPLY(3, "开票申请审批", "创建审批流", "开票审批完成"),
    INVOICE_RED_OFFSET(4, "红冲审批", "创建审批流", "红冲审批完成"),
    PAYMENT_APPLY(5, "付款申请记录审批", "创建审批流", "付款申请记录审批完成"),
    RECEIVED_PAYMENT_ASSOCIATION(6, "回款关联审批", "创建审批流", "回款关联审批审批完成"),
    RECEIVED_PAYMENT_DISASSOCIATION(7, "回款取消关联审批", "创建审批流", "回款取消关联审批审批完成"),
    CONTRACT(8, "合同审批", "创建审批流", "合同审批完成"),
    ;
    
    private final Integer type;
    
    private final String desc;

    /**
     * 发起人节点名称
     */
    private final String initActName;

    /**
     * 审批流结束后节点名称
     */
    private final String lastActName;
    
    private static final Map<Integer, WorkflowTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(WorkflowTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static WorkflowTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
