package cn.com.duiba.quanyi.center.api.remoteservice.partner;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.partner.PartnerDto;
import cn.com.duiba.quanyi.center.api.param.PartnerPageQueryParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * 客户管理
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemotePartnerService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合作客户
     */
    PartnerDto selectById(Long id);

    /**
     * 根据名称查询
     *
     * @param partnerName 名称
     * @return
     */
    PartnerDto findByName(String partnerName);

    /**
     * 根据全称查询
     *
     * @param partnerSubject 全称
     * @return 客户信息
     */
    PartnerDto findBySubject(String partnerSubject);

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 合作客户
     */
    List<PartnerDto> selectByIdList(Set<Long> ids);


    /**
     * 新增
     *
     * @param entity 合作客户
     * @return 执行结果
     */
    Long insert(PartnerDto entity);

    /**
     * 更新
     *
     * @param entity 合作客户
     * @return 执行结果
     */
    int update(PartnerDto entity);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询
     *
     * @return 活动
     */
    List<PartnerDto> selectPage(PartnerPageQueryParam param);

    /**
     * 分页查询-es
     * @param param
     * @return
     */
    Pair<Long,List<PartnerDto>> selectEsPage(PartnerPageQueryParam param);

    /**
     * 分页查询-数量
     *
     * @return 活动
     */
    Integer selectCount(PartnerPageQueryParam param);

    /**
     * count
     *
     * @param partnerPageQueryParam 查询参数
     * @return 匹配结果的行数
     */
    Integer countByParam(PartnerPageQueryParam partnerPageQueryParam);

    /**
     * count
     * @param partnerName 客户名称
     * @return 匹配结果的行数
     */
    Integer count(String partnerName);

    /**
     * 查询所有客户
     *
     * @return 活动
     */
    List<PartnerDto> findAll();

    /**
     * 根据创建人批量修改创建人信息
     * @param partnerDto 参数信息
     * @return 返回结果
     */
    Integer batchUpdateOperator(PartnerDto partnerDto);
}