package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 活动黑白名单表
 * @author mybatis generator
 * @date 2025-04-15
 */
@Data
public class ActivityBlackWhiteListDto implements Serializable {

    private static final long serialVersionUID = 17446989970564755L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 类型：1-白名单，2-黑名单
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityBlackWhiteListTypeEnum
     */
    private Integer listType;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 用户唯一标记
     */
    private String userMark;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    /**
     * 达标金额
     */
    private Long reachStandardAmount;

    /**
     * 发放金额
     */
    private Long grantAmount;

    /**
     * 是否限制领取数量
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer limitNum;

    /**
     * 总数量
     */
    private Long totalNum;

    /**
     * 已使用数量
     */
    private Long usedNum;

    /**
     * 用户ID_领取时间戳,用户ID_领取时间戳
     */
    private String takeInfo;

    /**
     * 上传任务id
     */
    private Long taskId;

    /**
     * 添加名单的操作人类型，1-内部sso用户，2-合作方员工
     */
    private Integer operatorType;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 添加人姓名
     */
    private String operatorName;

    /**
     * 最近更新名单的操作人类型，1-内部sso用户，2-合作方员工
     */
    private Integer updateOperatorType;

    /**
     * 最近更新人ID，用于排查问题
     */
    private Long updateOperatorId;

    /**
     * 最近更新人姓名，用于排查问题
     */
    private String updateOperatorName;

    /**
     * 删除名单的操作人类型，1-内部sso用户，2-合作方员工
     */
    private Integer deleteOperatorType;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;
}
