package cn.com.duiba.quanyi.center.api.dto.activity.common.ext;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/28 16:01
 */
@Data
public class ActivityCommonSignUpConfDto implements Serializable {
    
    private static final long serialVersionUID = 8447716875657384560L;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 报名形式
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSignUpTypeEnum
     */
    private Integer type;

    /**
     * 周期单位
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityPeriodicUnitEnum
     */
    private Integer periodicUnit;

    /**
     * 绝对时间
     */
    private List<ActivityCommonTimeLimitAbsoluteConfDto> absoluteTimeLimit;

    /**
     * 是否启用发奖校验报名
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableVerify;

    /**
     * 校验规则
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSignUpVerifyRuleTypeEnum
     */
    private Integer verifyRule;
}
