package cn.com.duiba.quanyi.center.api.dto.activity.common.take;

import cn.com.duiba.quanyi.center.api.dto.goods.ext.GoodsOrderExtAccountDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 15:36
 */
@Data
public class ActivityCommonTakeDto implements Serializable {

    private static final long serialVersionUID = -6932084844210600148L;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 发放账户信息
     */
    private GoodsOrderExtAccountDto goodsOrderExt;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户手机号（可为空）
     */
    private String userPhone;

    /**
     * 用户唯一标记
     */
    private String userMark;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 内部日志唯一标记，必传
     * 用于追溯 用户身份验证、黑名单、达标、报名等
     */
    private String innerLogMark;

    /**
     * 报名ID
     */
    private Long signUpId;

    /**
     * 助力次数ID
     */
    private Long assistTimesId;

    /**
     * 用户领取统计数据表ID
     */
    private Long userTakeStatId;

    /**
     * 活动纬度已领取数量，用于校验领取记录并发写入
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID，用于校验领取记录并发写入
     */
    private Long lastRecordId;

    /**
     * 白名单ID（活动维度白名单）
     */
    private Long whiteListId;

    /**
     * 要领取的奖品
     */
    private List<ActivityCommonPrizeTakeDto> prizeList;
}
