package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.Getter;

/**
 * @Description 模版活动达标数据,对应tb_activity_template_white_record中的字段
 * @Author cuizhoujian
 * @Date 2025-03-26 12:42:36
 */
@Getter
public enum TemplateWhiteRecordQueryFieldEnum {
    MOBILE(1, "手机号mobile"),
    CLIENT_NUMBER(2, "客户号client_number"),
    ;
    private final Integer type;
    private final String desc;

    TemplateWhiteRecordQueryFieldEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static TemplateWhiteRecordQueryFieldEnum getEnumByType(Integer type) {
        for (TemplateWhiteRecordQueryFieldEnum value : TemplateWhiteRecordQueryFieldEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
