package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.activity.BankEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/8/21 14:35
 */
@Data
public class WxCouponAllocationParam implements Serializable {
    
    private static final long serialVersionUID = 4054185207688365963L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private Integer stockType;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 微信返回的已发券数量
     */
    private Long distributedCoupons;

    /**
     * 用户领券后有效期为多少天，用于告警
     */
    private Integer userValidityPeriod;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;


    /**
     * 银行名称类型（可为空）
     * @see BankEnum ;
     */
    private String bankName;

    /**
     * 银行卡片类型（可为空）
     * @see cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
     */
    private String bankCardType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;

}
