package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import java.util.List;
import java.util.Set;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.PrizePeriodStockDto;

/**
 * 奖品周期库存远程服务
 * @author kjj mybatis generator 
 * @date 2025-04-25
 */ 
@AdvancedFeignClient
public interface RemotePrizePeriodStockService {

    /**
     * 根据奖品id筛选
     * @param prizeId 奖品id
     * @return 奖品周期库存列表
     */
    List<PrizePeriodStockDto> selectByPrizeId(Long prizeId);

    /**
     * 根据奖品id筛选
     * @param prizeIds 奖品id列表
     * @return 奖品周期库存列表
     */
    List<PrizePeriodStockDto> selectByPrizeIds(Set<Long> prizeIds);
}
