package cn.com.duiba.quanyi.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.LinkBindUserDto;
import cn.com.duiba.quanyi.center.api.param.qy.goods.LinkBindUserSearchParam;
import java.util.List;

/**
 * 短链绑定用户表
 * @author kjj mybatis generator 
 * @date 2024-09-27
 */
@AdvancedFeignClient
public interface RemoteLinkBindUserService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 短链绑定用户集合
     */
    List<LinkBindUserDto> selectPage(LinkBindUserSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LinkBindUserSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 短链绑定用户
     */
    LinkBindUserDto selectById(Long id);

    /**
     * 新增
     * @param dto 短链绑定用户
     * @return 执行结果
     */
    int insert(LinkBindUserDto dto);

    /**
     * 更新
     * @param dto 短链绑定用户
     * @return 影响行数
     */
    int update(LinkBindUserDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据订单号查询
     * @param goodOrderNo 主键
     * @return 短链绑定用户
     */
    LinkBindUserDto selectByGoodOrderNo(String goodOrderNo);
}