package cn.com.duiba.quanyi.center.api.utils.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/4/22 11:10
 */
@AllArgsConstructor
@Getter
public enum ActivityCommonErrorCodeEnum {
    AC999999("系统异常"),

    // 活动、配置 000
    AC000001("活动不存在"),
    AC000017("活动类型错误"),
    AC000004("活动扩展信息为空"),
    AC000005("活动奖品为空"),
    AC000006("奖品扩展信息为空"),
    AC000008("扩展信息存储数据类型不对"),
    AC000015("领取周期，单位错误"),
    AC000016("黑白名单，用户唯一标记类型不一样"),

    // 通用用户 001
    AC001001("用户详情不存在"),
    AC001002("用户不存在"),


    // 通用校验计算结果 002
    AC002001("校验-用户校验未配置"),
    AC002002("校验-用户API权限未校验"),
    AC002003("校验-用户API权限校验未通过/异常"),
    AC002004("校验-用户定制校验未验证"),
    AC002005("校验-用户定制校验未通过/异常"),
    AC002006("校验-可访问用户类型为空"),
    AC002007("校验-用户不在可访问类型内"),
    AC002008("校验-用户在黑名单内"),
    AC002009("校验-用户不在白名单内"),
    AC002010("校验-报名配置错误"),
    AC002011("校验-报名定制校验未验证"),
    AC002012("校验-报名定制校验验证不通过/异常"),
    AC002013("校验-本期未报名"),
    AC002014("校验-无上周期"),
    AC002015("校验-上周期未报名"),
    AC002016("校验-奖品不在白名单内"),
    AC002017("校验-白名单达标-未配置该奖品达标金额"),
    AC002018("校验-api达标-未验证"),
    AC002019("校验-api达标-未达标"),
    AC002020("校验-api达标-非达标奖品"),
    AC002021("校验-不可领取原因-不可参与"),
    AC002022("校验-不可领取原因-剩余次数为0"),
    AC002023("校验-不可领取原因-尚未支付"),
    AC002024("校验-不可支付原因-未开启支付"),
    AC002025("校验-不可支付原因-可参与"),
    AC002026("校验-不可支付原因-剩余次数为0"),
    AC002027("校验-不可支付原因-有尚未使用的支付凭证"),
    AC002028("校验-不展示用户ID原因-未启用"),
    AC002029("校验-不展示用户ID原因-配置的用户信息暂未支持"),
    AC002030("校验-不展示用户ID原因-获取到的值为空"),
    AC002031("校验-活动未启用"),
    AC002032("校验-活动尚未开始"),
    AC002033("校验-活动已结束"),
    AC002034("校验-活动当前时间不能访问"),

    // web 用户信息加载 003
    AC003001("用户信息加载-未实现用户API校验"),
    AC003002("用户信息加载-用户API校验返回data为null"),
    AC003003("用户信息加载-未实现用户定制校验"),
    AC003004("用户信息加载-用户定制校验返回data为null"),
    AC003005("用户信息加载-未实现API达标"),
    AC003006("用户信息加载-达标API返回data为null"),
    AC003007("用户信息加载-未实现报名定制校验"),
    AC003008("用户信息加载-报名定制校验返回data为null"),

    // web 领取 004

    // center 领取 005
    AC005001("领取-奖品ID对应奖品不存在"),
    AC005002("领取-保存领取记录失败"),
    AC005003("领取-保存领取记录异常"),
    AC005004("领取-用户领取统计更新失败"),
    AC005005("领取-支付凭证更新失败"),
    AC005006("领取-白名单扣减失败"),
    AC005007("领取-助力次数扣减失败"),
    AC005008("领取-领取商品类型超过上限"),

    ;
    private final String desc;
}
