package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.invoice.InvoiceSettlementRefTypeEnum;
import lombok.Data;

/**
 * 发票与结算单关系表
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
public class InvoiceSettlementRefDto implements Serializable {
     
    private static final long serialVersionUID = 173320673356366L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 发票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 发票ID
     */
    private Long invoiceId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 结算单占用金额
     */
    private Long occupyAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 回款ID，格式：回款ID_金额，回款ID_金额
     */
    private String receivedIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 关联类型：1-结算单开票，2-预付款抵扣
     * @see InvoiceSettlementRefTypeEnum
     */
    private Integer refType;

    /**
     * 结算分类
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementClassificationEnum
     */
    private Integer settlementClassification;

    /**
     * 预付款ID，类型为2时有值
     */
    private Long prepaymentId;

    /**
     * 使用的抵扣ID，类型为2时有值
     */
    private Long deductionId;

    /**
     * 使用的抵扣关系Id，类型为2时有值
     */
    private Long deductionRefId;

    /**
     * 预付款已抵扣金额-开票凭证为预付款时有意义
     */
    private Long prepaymentDeductionAmount;

    /**
     * 抵扣回款ID，格式：回款ID_金额，回款ID_金额-开票凭证为预付款时有意义
     */
    private String prepaymentDeductionReceivedIds;
}