package cn.com.duiba.quanyi.center.api.dto.mall.version;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.com.duiba.quanyi.center.api.enums.mall.MallDeliveryTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.mall.MallVersionTypeEnum;
import lombok.Data;

/**
 * 商城版本
 * @author mybatis generator 
 * @date 2024-06-11
 */
@Data
public class MallVersionDto implements Serializable {
     
    private static final long serialVersionUID = 17180959454412517L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 版本名称
     */
    private String versionName;

    /**
     * 版本状态：0-未上架，1-已上架
     * @see cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum
     */
    private Integer versionStatus;

    /**
     * 负责人Id
     */
    private Long ownerId;

    /**
     * 负责人姓名
     */
    private String ownerName;

    /**
     * 创建人ssoId
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 首页页面ID
     */
    private Long homePageId;

    /**
     * 我的页面ID
     */
    private Long myPageId;

    /**
     * 投放形式：0-小程序，1-H5
     *
     * @see MallDeliveryTypeEnum#getCode()
     */
    private Integer deliveryType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 版本类型
     * 0-保司 1-银行
     * @see MallVersionTypeEnum#getCode()
     */
    private Integer versionType;

    /**
     * 是否托管积分
     * 1-是 0-否
     */
    private Integer trusteeship;

    /**
     * 托管关联公司
     */
    private List<Long> companyIds;

    /**
     * 是否展示地址tab
     * 1-是 0-否
     */
    private Integer showAddressTab;

    /**
     * 汽车服务页面ID
     */
    private Long carSerPageId;

    /**
     * 生活服务页面ID
     */
    private Long lifeSerPageId;
}