package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum ActivityDrawLimitCycleEnum {

    NO(0, "不限制"),

    DAY(1, "日"),

    WEEK(2, "自然周"),

    MONTH(3, "自然月"),

    CUSTOM(4, "自定义周期"),

    ;

    private final Integer type;

    private final String desc;

    public static ActivityDrawLimitCycleEnum getEnumByType(Integer type) {
        for (ActivityDrawLimitCycleEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
