package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author nongfu
 * @Date 2024/6/20 19:44
 */
@Getter
@AllArgsConstructor
public enum ActivityKvEnum {

    COMMON_DRAW_SP("common_draw_sp_%s_%s", "模板活动通用抽奖key"),
    COMMON_ASSIST_SP("common_assist_sp_%s_%s", "模板活动通用助力key"),
    SAVE_REGISTRATION("save_registration_%s_%s_%s", "湖南长沙活动报名记录"),
    ACTIVITY_MONTH_DRAW_TAG("activity_month_draw_tag_%s_%s_%s", "活动每个周期领取一次"),
    COMMON_DRAW_EXPIRE_COUNT("draw_record_%s_%s_%s", "记录活动道具周期内消耗的次数"),
    ACTIVITY_PAY_COUNT("activity_pay_count_%s_%s", "模版活动-活动维度支付次数"),
    PRIZE_PAY_COUNT("prize_pay_count_%s_%s_%s", "模版活动-奖品维度支付次数"),
    USER_DRAW_COUNT("user_draw_count_%s_%s_%s", "模版活动-用户抽奖次数"),
    BOC_SH_USER_WHITE("boc_sh_user_white_%s_%s", "模版活动-上海中行用户白名单"),
    ACTIVITY_SIGN_UP("activity_sign_up_%s_%s_%s", "活动报名记录"),
    TEMPLATE_ACTIVITY_BOC_JOIN_RECORD("boc_qd_ac_rc_%s_%s", "模版活动-青岛中行月月礼活动参与活动记录"),
    TEMPLATE_ACTIVITY_QD_BOC_INV_JOIN_RECORD("boc_qd_ac_inv_%s_%s", "模版活动-青岛中行受邀礼活动参与活动记录"),
    BOC_HBSX_ACTIVITY_SIGN_UP("boc_hbsx_activity_sign_up_%s_%s", "湖北三峡活动报名记录"),
    BOC_ZJ_MALL_CONFIG("boc_zj_mall_config", "浙江百城商圈活动配置"),
    ;

    private final String key;

    private final String desc;


    /**
     * 需要对应好否则会报错
     * @param key
     * @param args
     * @return
     */
    public static String getKey(String key, Object... args){
      return String.format(key, args);
    }

}
