package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/3/28 16:43
 **/
@Getter
@AllArgsConstructor
public enum StampTypeEnum {
    OFFICIAL_STAMP(1, "公章"),
    LEGAL_PERSON_STAMP(2, "法人章"),
    CONTRACT_STAMP(3, "合同章"),
    ;

    private final Integer type;
    private final String desc;

    public static String getDesc(Integer type) {
        for (StampTypeEnum stampTypeEnum : StampTypeEnum.values()) {
            if (stampTypeEnum.getType().equals(type)) {
                return stampTypeEnum.getDesc();
            }
        }
        return null;
    }
}
