package cn.com.duiba.quanyi.center.api.param.qystatistic;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝核销数据统计表
 * @author mybatis generator 
 * @date 2024-08-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AlipayActWriteOffStatisticDataSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17237888613624964L;

    /**
     * 支付宝活动id
     */
    private String alipayActId;

    /**
     * 支付宝活动名称
     */
    private String alipayActName;

    /**
     * 配置日期 - 开始日期
     */
    private Date startDate;

    /**
     * 配置日期 - 结束日期
     */
    private Date endDate;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 结算主体
     */
    private String settlementEntity;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 配置主体：列表筛选
     */
    private String configEntity;

    /**
     * 运营负责人
     */
    private String operationManagerName;

    /**
     * 月份：只作用于数值变化
     */
    private Date month;

    /**
     * 支付宝活动状态,CREATED="已创建",PUBLISHING="发布中",PUBLISHED_FAILED="发布失败",GREY="已发布(白名单验证中)",GOING="已发布",PAUSED="已暂停",ENDED="已结束"
     */
    private String alipayActStatus;

    /**
     * 排序字段
     */
    private String sortFiled;

    /**
     * true - DESC
     * FALSE - ASC
     */
    private Boolean desc;

    /**
     * 项目id
     */
    private Long projectId;
}