package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementGoodsRangeDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementGoodsRangeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 结算单-商品范围
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementGoodsRangeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单-商品范围集合
     */
    List<SettlementGoodsRangeDto> selectPage(SettlementGoodsRangeSearchParam param);
    
    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SettlementGoodsRangeSearchParam param);

    /**
     * 批量新增
     * @param list 结算单-商品范围
     * @return key：唯一标记，value：主键
     */
    Map<String, Long> batchInsert(List<SettlementGoodsRangeDto> list);
}