package cn.com.duiba.quanyi.center.api.remoteservice.external;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderCouponDto;
import cn.com.duiba.quanyi.center.api.param.external.ExternalOrderCouponSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 外部订单批次号
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteExternalOrderCouponService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 外部订单批次号集合
     */
    List<ExternalOrderCouponDto> selectPage(ExternalOrderCouponSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 外部订单批次号集合
     */
    List<ExternalOrderCouponDto> selectNotPage(ExternalOrderCouponSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ExternalOrderCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 外部订单批次号
     */
    ExternalOrderCouponDto selectById(Long id);

    /**
     * 根据主键查询
     * @param ids 主键
     * @return 外部订单批次号
     */
    List<ExternalOrderCouponDto> selectByIds(Set<Long> ids);

    /**
     * 新增
     * @param dto 外部订单批次号
     * @return 执行结果
     */
    int insert(ExternalOrderCouponDto dto);

    /**
     * 更新
     * @param dto 外部订单批次号
     * @return 影响行数
     */
    int update(ExternalOrderCouponDto dto);

    /**
     * 批量更新
     * @param dtos 外部订单批次号
     * @return 影响行数
     */
    int batchUpdate(List<ExternalOrderCouponDto> dtos);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量删除外部订单批次
     * @param couponIds 主键
     * @return 删除条数
     */
    int batchDeleteCoupon(List<Long> couponIds);
}