package cn.com.duiba.quanyi.center.api.remoteservice.pay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pay.PayOrderDto;
import cn.com.duiba.quanyi.center.api.dto.pay.PayOrderEsDto;
import cn.com.duiba.quanyi.center.api.dto.pay.PayResultDto;
import cn.com.duiba.quanyi.center.api.dto.pay.WxMpOrderRetryPayResultDto;
import cn.com.duiba.quanyi.center.api.dto.pay.create.ext.PayCreateOrderResultExtDto;
import cn.com.duiba.quanyi.center.api.param.pay.PayOrderEsSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * 支付通用服务
 * @author lizhi
 * @date 2023/9/20 18:16
 */
@AdvancedFeignClient
public interface RemotePayOrderService {

    /**
     * 根据订单号查询
     * @param bizOrderNo 订单号
     * @return 支付订单
     */
    PayOrderDto selectByBizOrderNo(String bizOrderNo);

    /**
     * 根据id查询
     *
     * @param id id
     * @return 支付订单
     */
    PayOrderDto selectById(Long id);

    /**
     * 根据订单号批量查询
     * @param bizOrderNos 订单号
     * @return 支付订单
     */
    List<PayOrderDto> selectByBizOrderNos(Set<String> bizOrderNos);

    /**
     * 查询状态值最大的一个非失败、非取消状态的订单
     * @param userId 用户ID
     * @param payBizType 订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     * @param payBizId 订单业务主键
     * @return 支付记录
     */
    PayOrderDto selectMaxStatusAndNotFailCancel(Long userId, Integer payBizType, Long payBizId);
    /**
     * C端-用户支付记录分页查询
     * @param userId 用户ID
     * @param payBizType 订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     * @param payBizId 订单业务主键
     * @param lastId 上次最后一个ID，第一页为null
     * @param pageSize 需要拉去的条数
     * @return 支付记录
     */
    List<PayOrderDto> selectUserList(Long userId, Integer payBizType, Long payBizId, Long lastId, Integer pageSize);

    /**
     * 重新支付
     * @param bizOrderNo 订单号
     * @return 结果
     */
    WxMpOrderRetryPayResultDto retryPay(String bizOrderNo);
    
    /**
     * 重新支付
     * @param bizOrderNo 订单号
     * @return 结果
     */
    PayCreateOrderResultExtDto retryPayNew(String bizOrderNo);

    /**
     * 查询订单信息，若需要则异步触发查询支付平台
     * @param bizOrderNo 订单号
     * @return 订单信息
     */
    PayResultDto getAndSyncIfAbsent(String bizOrderNo);

    /**
     * 取消
     * @param bizOrderNo 订单号
     * @return 是否成功
     */
    boolean cancel(String bizOrderNo);

    /**
     * 退款
     * @param bizOrderNo 订单号
     * @param refundReason 退款原因
     */
    void refund(String bizOrderNo, String refundReason);

    /**
     * 根据条件搜索订单
     *
     * @param param 搜索条件
     * @return 订单实体
     */
    Pair<Long, List<PayOrderEsDto>> search(PayOrderEsSearchParam param);

    /**
     * 根据id查询订单
     *
     * @param id 订单id
     * @return 订单实体
     */
    PayOrderEsDto searchById(Long id);
}
