package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityBizRelationDto;

/**
 * 活动业务关联关系表
 * @author kjj mybatis generator 
 * @date 2025-02-13
 */
@AdvancedFeignClient
public interface RemoteActivityBizRelationService {

    /**
     * 根据bizContext查询
     * @param bizContext bizContext
     * @param bizType 业务类型
     * @param activityId 活动ID
     * @return 符合条件的记录数
     */
    List<ActivityBizRelationDto> queryRecordByBizContext(String bizContext, Long activityId, String bizType);

    /**
     * 根据bizId查询
     * @param bizId bizID
     * @param bizType 业务类型
     * @param activityId 活动ID
     * @return 符合条件的记录数
     */
    List<ActivityBizRelationDto> queryRecordByBizId(String bizId, Long activityId, String bizType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动业务关联关系
     */
    ActivityBizRelationDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动业务关联关系
     * @return 执行结果
     */
    int insert(ActivityBizRelationDto dto);

    /**
     * 更新
     * @param dto 活动业务关联关系
     * @return 影响行数
     */
    int update(ActivityBizRelationDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}