package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxAutoCreateResultDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponAutoCreateTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxAutoCreateResultSearchParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponAutoCreateResultNotifyParam;

import java.util.List;

/**
 * 自动创建微信立减金
 *
 * @author xuzhigang
 * @date 2024/3/25 17:52
 **/
@AdvancedFeignClient
public interface RemoteWxCouponAutoCreateService {
    /**
     * 批量初始化自动创建任务
     *
     * @param stockType {@link cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum}
     * @param list 自动创建批次任务列表
     */
    void batchInit(Integer stockType, List<WxCouponAutoCreateTaskDto> list);

    /**
     * 创建结果通知
     *
     * @param list 通知参数
     */
    void createResultNotify(List<WxCouponAutoCreateResultNotifyParam> list);

    /**
     * 绑定批次id
     *
     * @param taskId 任务id
     * @param stockId 批次id
     * @return 绑定结果
     */
    boolean bindStockId(Long taskId, String stockId);

    /**
     * 根据上传任务id查询微信批次自动创建结果
     * @param param 查询参数
     * @return 结果列表
     */
    List<WxAutoCreateResultDto> selectWxAutoCreateResult(WxAutoCreateResultSearchParam param);

}
