package cn.com.duiba.quanyi.center.api.enums.activity.common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/4/28 10:13
 */
@Getter
@AllArgsConstructor
public enum ActivityCommonSubTypeEnum {
    TEMPLATE(1, "模板活动", false),
    BOC_COMMON(2, "中行通用活动", true),
    
    TEST_CUSTOM(999999999, "测试定制活动", true),
    ;

    private final Integer type;

    private final String desc;

    /**
     * 是否是定制
     */
    private final boolean custom;

    /**
     * 根据type获取枚举信息
     */
    public static ActivityCommonSubTypeEnum getByType(Integer type) {
        return Arrays.stream(ActivityCommonSubTypeEnum.values())
                .filter(item -> item.getType().equals(type))
                .findFirst()
                .orElse(null);
    }

    /**
     * 查询所有定制活动
     */
    public static List<ActivityCommonSubTypeEnum> getCustomEnums() {
        return Arrays.stream(ActivityCommonSubTypeEnum.values())
                .filter(ActivityCommonSubTypeEnum::isCustom)
                .collect(Collectors.toList());
    }
}
