package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/3/28 18:17
 **/
@Getter
@AllArgsConstructor
public enum ContractStatusEnum {
    INIT(0, "初始化"),
    APPROVAL(1, "审批中"),
    APPROVAL_REJECT(2, "审批拒绝"),
    ARCHIVED(3, "已归档"),
    TERMINATED(4, "已撤销"),
    ;

    private final Integer status;
    private final String desc;

    public static boolean isValid(Integer status) {
        return APPROVAL.status.equals(status) || ARCHIVED.status.equals(status);
    }

    public static boolean isInvalid(Integer status) {
        return APPROVAL_REJECT.status.equals(status) || TERMINATED.status.equals(status);
    }
}
