package cn.com.duiba.quanyi.center.api.enums.settlement.receive;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 回款所属业务枚举
 * @author yinjiaqi
 * @date 2025-06-09 13:46:04
 */
@Getter
@AllArgsConstructor
public enum ReceivedBelongingBusinessEnum {
    BANK_CHANNEL_BUSINESS(1, "银行渠道"),
    INSURANCE_BUSINESS(2, "保险业务"),
    INNOVATION_BUSINESS(3, "创新业务"),
    DIGITAL_MARKETING(4, "数字营销"),
    OTHER(5, "其他"),
    ;

    private static final Map<String, ReceivedBelongingBusinessEnum> DESC_ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ReceivedBelongingBusinessEnum::getDesc, Function.identity(), (v1, v2) -> v2)));
    private static final Map<Integer, ReceivedBelongingBusinessEnum> CODE_ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ReceivedBelongingBusinessEnum::getCode, Function.identity(), (v1, v2) -> v2)));


    private final Integer code;
    private final String desc;

    public static ReceivedBelongingBusinessEnum getEnumByDesc(String desc) {
        return DESC_ENUM_MAP.get(desc);
    }

    public static ReceivedBelongingBusinessEnum getEnumByCode(Integer code) {
        return CODE_ENUM_MAP.get(code);
    }
}

