package cn.com.duiba.quanyi.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 微信商户关联外部商户号
 * @author mybatis generator 
 * @date 2025-01-06
 */
@Data
public class WxMchExternalRefDto implements Serializable {
     
    private static final long serialVersionUID = 17361550332179907L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 删除人ssoid
     */
    private Long deleteSsoId;

    /**
     * 删除人sso姓名
     */
    private String deleteSsoName;

    /**
     * 微信商户号
     */
    private String mchId;

    /**
     * 外部微信商户号
     */
    private String externalMchId;

    /**
     * 外部商户号备注
     */
    private String mchRemark;

    /**
     * 创建人ssoid
     */
    private Long createSsoId;

    /**
     * 创建人sso姓名
     */
    private String createSsoName;
}