package cn.com.duiba.quanyi.center.api.enums.bill;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 账单类型
 *
 * @author xuzhigang
 * @date 2024/2/23 15:34
 **/
@Getter
@AllArgsConstructor
public enum BillBizTypeEnum {
    JXYS(1, "江西银商"),
    SXGH(2, "山西工行"),
    OTHER(3, "其他"),
    JSGH(4, "江苏工行"),
    HZYH(5, "杭州银行"),

    ZGYH(6, "中国银行"),
    ;

    private Integer type;

    private String desc;

    public static BillBizTypeEnum convert(Integer type) {
        for (BillBizTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

}
