package cn.com.duiba.quanyi.center.api.dto.workflow;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/4/17 16:21
 **/
@Data
public class WorkflowApprovalOperationDto implements Serializable {
    private static final long serialVersionUID = -7938201876407637765L;

    /**
     * 任务节点ID
     */
    public String activityId;

    public List<String> ccUserIds;

    /**
     * 抄送人userIds列表。
     */
    public String date;

    /**
     * 单个图片链接
     */
    public List<String> images;

    /**
     * 评论内容。
     */
    public String remark;

    /**
     * 操作结果。
     * AGREE：同意
     * REFUSE：拒绝
     * NONE：未处理
     */
    public String result;

    /**
     * 任务节点名称
     */
    public String showName;

    /**
     * 操作类型。
     * EXECUTE_TASK_NORMAL：正常执行任务
     * EXECUTE_TASK_AGENT：代理人执行任务
     * APPEND_TASK_BEFORE：前加签任务
     * APPEND_TASK_AFTER：后加签任务
     * REDIRECT_TASK：转交任务
     * START_PROCESS_INSTANCE：发起流程实例
     * TERMINATE_PROCESS_INSTANCE：终止(撤销)流程实例
     * FINISH_PROCESS_INSTANCE：结束流程实例
     * ADD_REMARK：添加评论
     * REDIRECT_PROCESS：审批退回
     * PROCESS_CC：抄送
     */
    public String type;

    /**
     * 操作人userId。
     */
    public String userId;
}
