package cn.com.duiba.quanyi.center.api.param.psbc;

import lombok.Data;

import java.util.Map;

/**
 * 邮储采购下单业务扩展参数
 *
 * @author wangguanhua
 */
@Data
public class PsbcSupplyBizJsonExtParam {

    /**
     * key：prizeId value：发奖次数
     */
    private Map<Long, Integer> prizeCountMap;

    /**
     * 最终的子订单数量（自动塞券定制有值，此时 apiOrderEntity 中的 subOrderCount 并不表示最终的 goodsOrderEntity 数量）
     */
    private Integer finalSubOrderCount;

    /**
     * 是否已推送充值状态
     */
    private Boolean pushedRechargedStatus;

    /**
     * 20元3张，10元2张，remake格式：["20:3","10:2"]
     */
    private String psbcRemark;
}
