package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.quanyi.center.api.dto.demand.DemandRefundContractAmountTaskDetailDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandRefundContractAmountTaskDetailSearchParam;

import java.util.List;

/**
 * 需求回退合同金额任务明细RemoteService
 *
 * @author xuzhigang
 * @date 2025-09-08 16:30
 */
public interface RemoteDemandRefundContractAmountTaskDetailService {

    /**
     * 分页查询
     * @param param 查询参数
     * @return DTO对象列表
     */
    List<DemandRefundContractAmountTaskDetailDto> selectPage(DemandRefundContractAmountTaskDetailSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    long count(DemandRefundContractAmountTaskDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return DTO对象
     */
    DemandRefundContractAmountTaskDetailDto selectById(Long id);

    /**
     * 根据任务ID查询
     * @param taskId 任务ID
     * @return DTO对象列表
     */
    List<DemandRefundContractAmountTaskDetailDto> selectByTaskId(Long taskId);

    /**
     * 新增
     * @param dto DTO对象
     * @return 主键ID
     */
    Long insert(DemandRefundContractAmountTaskDetailDto dto);

    /**
     * 更新
     * @param dto DTO对象
     * @return 影响行数
     */
    int update(DemandRefundContractAmountTaskDetailDto dto);
}
