package cn.com.duiba.quanyi.center.api.remoteservice.activity.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonUserApiVerifyDto;

import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2025/4/21 16:09
 */
@AdvancedFeignClient
public interface RemoteActivityCommonUserApiVerifyService {

    /**
     * 查询用户验证结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 验证结果
     */
    ActivityCommonUserApiVerifyDto get(Long userId, Long activityId);

    /**
     * 设置用户验证结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param dto 结果
     * @param timeout 缓存时间
     * @param unit 时间单位
     * @return 是否成功
     */
    boolean set(Long userId, Long activityId, ActivityCommonUserApiVerifyDto dto, int timeout, TimeUnit unit);
}
