package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceReceivedOverdueRankDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceReceivedOverdueRankSearchParam;

import java.util.List;

/**
 * 发票回款超期排行榜远程服务
 * @author xuzhigang
 * @date 2025/1/21
 */
@AdvancedFeignClient
public interface RemoteInvoiceReceivedOverdueRankService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 排行榜记录
     */
    InvoiceReceivedOverdueRankDto selectById(Long id);

    /**
     * 新增排行榜记录
     * @param dto 排行榜记录
     * @return 执行结果
     */
    int insert(InvoiceReceivedOverdueRankDto dto);

    /**
     * 更新排行榜记录
     * @param dto 排行榜记录
     * @return 执行结果
     */
    int update(InvoiceReceivedOverdueRankDto dto);

    /**
     * 根据项目ID查询排行榜记录
     * @param projectId 项目ID
     * @return 排行榜记录
     */
    InvoiceReceivedOverdueRankDto selectByProjectId(Long projectId);

    /**
     * 分页查询排行榜
     * @param param 查询参数
     * @return 排行榜列表
     */
    List<InvoiceReceivedOverdueRankDto> selectPage(InvoiceReceivedOverdueRankSearchParam param);

    /**
     * 查询排行榜记录总数
     * @param param 查询参数
     * @return 总记录数
     */
    long selectCount(InvoiceReceivedOverdueRankSearchParam param);

    /**
     * 保存或更新排行榜记录
     * @param dto 排行榜记录
     * @return 执行结果
     */
    int saveOrUpdate(InvoiceReceivedOverdueRankDto dto);
}
