package cn.com.duiba.quanyi.center.api.remoteservice.refund;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.refund.RefundScanTaskDto;
import cn.com.duiba.quanyi.center.api.param.refund.RefundScanTaskPageQueryParam;

/**
 * 退款定时扫描任务远程服务接口
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@AdvancedFeignClient
public interface RemoteRefundScanTaskService {

    /**
     * 分页查询退款扫描任务
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<RefundScanTaskDto> selectPage(RefundScanTaskPageQueryParam param);

    /**
     * 根据条件查询总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    long selectCount(RefundScanTaskPageQueryParam param);

    /**
     * 根据ID查询退款扫描任务
     *
     * @param id 主键ID
     * @return 退款扫描任务
     */
    RefundScanTaskDto selectById(Long id);

    /**
     * 根据业务类型和业务ID查询
     *
     * @param businessType 业务类型
     * @param businessId 业务ID
     * @return 退款扫描任务
     */
    RefundScanTaskDto selectByBusinessTypeAndId(Integer businessType, Long businessId);

    /**
     * 插入退款扫描任务
     *
     * @param dto 退款扫描任务DTO
     * @return 影响行数
     */
    int insert(RefundScanTaskDto dto);
}
