package cn.com.duiba.quanyi.center.api.remoteservice.settlement.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.OrderStatDto;

import java.util.List;
import java.util.Set;

/**
 * 订单统计表
 * @author kjj mybatis generator 
 * @date 2024-11-26
 */
@AdvancedFeignClient
public interface RemoteOrderStatService {

    /**
     * 根据统计纬度查询
     * @param statId 统计纬度ID
     * @param statType 统计纬度类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.stat.SettlementOrderStatTypeEnum
     * @return 订单统计
     */
    OrderStatDto selectByStat(String statId, Integer statType);

    /**
     * 根据统计纬度批量查询
     * @param statIds 统计纬度ID
     * @param statType 统计纬度类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.stat.SettlementOrderStatTypeEnum
     * @return 订单统计
     */
    List<OrderStatDto> selectListByStat(Set<String> statIds, Integer statType);
}