package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * 券码业务类型
 *
 * @author lizhi
 * @date 2023/9/14 11:47
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderBizTypeEnum {
    // 基于活动领取记录的所有活动
    ACTIVITY_GENERAL(1, "通用活动"),
    GOODS_PKG(2, "商品包"),
    API(3, "API供货"),
    INSURANCE(4, "保司权益"),
    MALL(5, "商城"),
    EQUITY_COUPON(6, "权益券"),
    ACTIVITY_COMMON(7, "新版通用活动"),
    ;


    public static final Set<Integer> NEED_PUSH_SHORT_URL_TYPE = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            ACTIVITY_GENERAL.getType()
            , API.getType()
    )));

    private final Integer type;

    private final String desc;
}
