package cn.com.duiba.quanyi.center.api.param.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 打款申请-供应商预付款查询参数
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@Data
public class PaymentInfoSupplierPrepaymentSearchParam implements Serializable {
     
    private static final long serialVersionUID = 17345671234567898L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键列表
     */
    private List<Long> ids;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 供应商ID列表
     */
    private List<Long> supplierIds;

    /**
     * 预付款名称
     */
    private String prepaymentName;

    /**
     * 状态
     */
    private Integer prepaymentStatus;

    /**
     * 状态列表
     */
    private List<Integer> prepaymentStatusList;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 付款ID
     */
    private Long paymentId;

    /**
     * 付款ID列表
     */
    private List<Long> paymentIds;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 修改时间开始
     */
    private Date gmtModifiedStart;

    /**
     * 修改时间结束
     */
    private Date gmtModifiedEnd;

    /**
     * 分页偏移量
     */
    private Integer offset;

    /**
     * 分页大小
     */
    private Integer pageSize;
}
