package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;
import java.util.Objects;

/**
 * @author zzy
 * @date 2025/08/05 15:54
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BankMultiActivityAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {
    private static final long serialVersionUID = -1758978705889443840L;

    /**
     * 活动备注
     */
    private String activityRemark;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡类型 1-借记卡 2-信用卡
     */
    private Integer bankCardType;

    /**
     * 卡片名称
     */
    private String bankCardName;

    /**
     * 卡bin号列表
     */
    private List<String> cardBinList;


    /* ---------------------------优惠规则---------------------------- */
    /**
     * 优惠形式（1-多笔随机立减，2-多笔定额立减）
     */
    private Integer discountType;

    /**
     * 用户参与笔数上限，3-31
     */
    private Integer userUseCountLimit;

    /**
     * 优惠配置，与用户参与笔数上限映射，当选择2-多笔定额立减时生效
     * 比如：1-10.00-1.00 第一笔优惠，满10元减1元
     */
    private List<String> discountRuleList;

    /**
     * 单用户预算上限，0.5-100
     */
    private String singleUserAmountLimit;

    /**
     * 多笔定额立减时，基于discountRule计算而来，可以用于校验总预算配置是否正确
     */
    private String singleUserAmountLimitForFix;

    /**
     * 单笔交易门槛限制类型
     */
    private Integer singleTradeLimitType;

    /**
     * 单笔交易门槛限制金额, 设置后，用户交易订单金额需满足指定门槛，才可享立减优惠
     * 0.1-5000
     */
    private String singleTradeLimitAmount;

    /**
     * 单日用户可享优惠限制类型
     */
    private Integer userDayLimitType;

    /**
     * 单日用户可享优惠次数上限
     */
    private Integer userDayLimitCount;

    /* ---------------------------活动规则---------------------------- */

    /**
     * 活动报名起始日期 yyyy-MM-dd / yyyy/MM/dd
     */
    private String startDate;

    /**
     * 活动报名结束日期 yyyy-MM-dd / yyyy/MM/dd
     */
    private String endDate;

    /**
     * 参与后享受优惠的天数
     */
    private Integer effectDays;

    /**
     * 活动总预算
     */
    private String budgetAmount;

    /**
     * 单日发放预算上限开关（1-不限，2-限制）
     */
    private Integer dayLimitType;

    /**
     * 单日发放预算上限金额（元）
     */
    private String dayLimitAmount;

    /* ---------------------------发放规则---------------------------- */
    /**
     * 发放方式（1-API发放，2-平台发放）
     */
    private Integer sendType;

    /**
     * （可选）其他商户号，选择API发放时，且需要跨商户号发放
     */
    private String otherMchId;

    /**
     * 投放人群（1-微信标签 2-银行号码包）
     */
    private Integer targetPeople;

    /**
     * 时间周期（1-10天内，2-30天内，3-60天内，4-90天内，5-120天内，6-150天内，7-180天内，8-210天内，9-240天内，10-270天内，11-300天内，12-330天内，13-365天内）
     */
    private Integer timePeriod;

    /**
     * 用卡行为（1-不指定用卡行为 2-指定用卡行为）
     */
    private Integer useCard;

    /**
     * 用卡行为类型（1-交易笔数区间 2-交易金额区间）
     */
    private Integer useCardType;

    /**
     * 交易笔数区间起始，>=0，<=1000
     */
    private Integer tradeCountStart;

    /**
     * 交易笔数区间结束，>=0，<=1000，交易笔数区间结束>交易笔数区间起始
     */
    private Integer tradeCountEnd;

    /**
     * 交易金额区间起始，>=0，保留到分
     */
    private String tradeAmountStart;

    /**
     * 交易金额区间结束，>=0，保留到分，交易金额区间结束>交易金额区间起始
     */
    private String tradeAmountEnd;

    /**
     * 绑卡时间（1-不限绑卡时间 2-指定时间内新绑卡用户）
     */
    private Integer bindCardTime;

    /**
     * 号码包id
     */
    private String packageId;

    /**
     * 是否自动加款 0-不自动加款 1-自动加款
     */
    private Integer autoAddMoney;

    /**
     * 商品ID
     */
    private Long demandGoodsId;

    /**
     * 创建人Id,ssoId
     */
    private Long creatorId;

    /**
     * 创建人名称,ssoName
     */
    private String creatorName;

    public String getCouponAmount(){
        if (Objects.equals(1, discountType)){
            return singleUserAmountLimit;
        } else if (Objects.equals(2, discountType)){
            return singleUserAmountLimitForFix;
        }
        return null;
    }
}

