package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoSupplierInboundDto;

import java.util.List;

/**
 * 供应商付款记录与入库单关联关系远程服务接口
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@AdvancedFeignClient
public interface RemotePaymentInfoSupplierInboundService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商付款记录与入库单关联关系
     */
    PaymentInfoSupplierInboundDto selectById(Long id);

    /**
     * 根据供应商付款ID查询
     * @param supplierPaymentId 供应商付款ID
     * @return 供应商付款记录与入库单关联关系列表
     */
    List<PaymentInfoSupplierInboundDto> selectBySupplierPaymentId(Long supplierPaymentId);

    /**
     * 根据结算单ID查询
     * @param settlementId 结算单ID
     * @return 供应商付款记录与入库单关联关系列表
     */
    List<PaymentInfoSupplierInboundDto> selectBySettlementId(Long settlementId);

    /**
     * 根据入库单ID查询
     * @param inboundOrderId 入库单ID
     * @return 供应商付款记录与入库单关联关系列表
     */
    List<PaymentInfoSupplierInboundDto> selectByInboundOrderId(Long inboundOrderId);

    /**
     * 新增
     * @param dto 供应商付款记录与入库单关联关系
     * @return 主键
     */
    Long insert(PaymentInfoSupplierInboundDto dto);

    /**
     * 批量新增
     * @param list 供应商付款记录与入库单关联关系列表
     * @return 执行结果
     */
    Integer batchInsert(List<PaymentInfoSupplierInboundDto> list);

    /**
     * 更新
     * @param dto 供应商付款记录与入库单关联关系
     * @return 执行结果
     */
    Integer update(PaymentInfoSupplierInboundDto dto);

    /**
     * 批量更新
     * @param list 供应商付款记录与入库单关联关系列表
     * @return 执行结果
     */
    Integer batchUpdate(List<PaymentInfoSupplierInboundDto> list);
}
