package cn.com.duiba.quanyi.center.api.param.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 订单统计表-日维度
 * @author mybatis generator 
 * @date 2025-02-26
 */
@Data
public class OrderStatDailySearchParam implements Serializable {
     
    private static final long serialVersionUID = 17405676724894034L;

    /**
     * 统计纬度ID，类型=1-项目ID字符串
     */
    private String statId;

    /**
     * 统计纬度ID列表
     */
    private List<String> statIdList;

    /**
     * 统计纬度类型：1-项目
     */
    private Integer statType;

    /**
     * 商品类型
     * {@link cn.com.duiba.quanyi.center.api.enums.statistic.DailyOrderStatGoodsTypeEnum}
     */
    private Integer goodsType;

    /**
     * 订单开始日期
     */
    private Date orderDateStart;

    /**
     * 订单结束日期
     */
    private Date orderDateEnd;
}