package cn.com.duiba.quanyi.center.api.enums.invoice;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/10/08 17:57
 */
@AllArgsConstructor
@Getter
public enum InvoiceApplyTaskBizTypeEnum {
    INVOICE_APPLY_LOCK(1, "开票申请锁定"),
    SUPPLIER_PAYMENT_LOCK(2, "供应商结算单锁定"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, InvoiceApplyTaskBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InvoiceApplyTaskBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InvoiceApplyTaskBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
