package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoSupplierPrepaymentDto;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoSupplierPrepaymentStatisticsDto;
import cn.com.duiba.quanyi.center.api.param.payment.PaymentInfoSupplierPrepaymentSearchParam;
import cn.com.duiba.quanyi.center.api.param.payment.SupplierPrepaymentApplyPaymentParam;

import java.util.List;

/**
 * 打款申请-供应商预付款远程服务接口
 * @author xuzhigang
 * @date 2025-09-17 16:20
 */
@AdvancedFeignClient
public interface RemotePaymentInfoSupplierPrepaymentService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 打款申请-供应商预付款
     */
    PaymentInfoSupplierPrepaymentDto selectById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 打款申请-供应商预付款列表
     */
    List<PaymentInfoSupplierPrepaymentDto> selectByIds(List<Long> ids);

    /**
     * 根据供应商ID查询
     * @param supplierId 供应商ID
     * @return 打款申请-供应商预付款列表
     */
    List<PaymentInfoSupplierPrepaymentDto> selectBySupplierId(Long supplierId);

    /**
     * 根据供应商ID列表查询
     * @param supplierIds 供应商ID列表
     * @return 打款申请-供应商预付款列表
     */
    List<PaymentInfoSupplierPrepaymentDto> selectBySupplierIds(List<Long> supplierIds);

    /**
     * 根据付款ID查询
     * @param paymentId 付款ID
     * @return 打款申请-供应商预付款列表
     */
    List<PaymentInfoSupplierPrepaymentDto> selectByPaymentId(Long paymentId);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 打款申请-供应商预付款列表
     */
    List<PaymentInfoSupplierPrepaymentDto> selectPage(PaymentInfoSupplierPrepaymentSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    Long selectCount(PaymentInfoSupplierPrepaymentSearchParam param);

    /**
     * 新增
     * @param dto 打款申请-供应商预付款
     * @return 主键
     */
    Long insert(PaymentInfoSupplierPrepaymentDto dto);

    /**
     * 批量新增
     * @param list 打款申请-供应商预付款列表
     * @return 执行结果
     */
    Integer batchInsert(List<PaymentInfoSupplierPrepaymentDto> list);

    /**
     * 更新
     * @param dto 打款申请-供应商预付款
     * @return 执行结果
     */
    Integer update(PaymentInfoSupplierPrepaymentDto dto);

    /**
     * 批量更新
     * @param list 打款申请-供应商预付款列表
     * @return 执行结果
     */
    Integer batchUpdate(List<PaymentInfoSupplierPrepaymentDto> list);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    Integer delete(Long id);

    /**
     * 批量逻辑删除
     * @param ids 主键列表
     * @return 执行结果
     */
    Integer batchDelete(List<Long> ids);

    /**
     * 根据供应商ID查询统计数据
     * @param supplierId 供应商ID
     * @return 供应商预付款统计数据
     */
    PaymentInfoSupplierPrepaymentStatisticsDto selectStatisticsBySupplierId(Long supplierId);

    /**
     * 供应商预付款申请付款
     *
     * @param param 申请付款参数
     * @return 付款id
     */
    Long applyPayment(SupplierPrepaymentApplyPaymentParam param);
}
