package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/3/28 16:35
 **/
@Getter
@AllArgsConstructor
public enum ArchiveTypeEnum {
    PAPER_ARCHIVE(1, "纸质版归档"),
    EMAIL_ARCHIVE(2, "邮件归档"),
    ELECTRONIC_ARCHIVE(3, "电子版归档"),
    DIRECT_PAYMENT_ARCHIVE(4, "直接打款归档（无合同）"),
    ;

    private final Integer type;
    private final String desc;

    public static String getDescByType(Integer type) {
        for (ArchiveTypeEnum archiveTypeEnum : ArchiveTypeEnum.values()) {
            if (archiveTypeEnum.getType().equals(type)) {
                return archiveTypeEnum.getDesc();
            }
        }
        return null;
    }
}
