package cn.com.duiba.quanyi.center.api.enums.pay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付结果状态（展示给C端用户的）
 * @author lizhi
 * @date 2023/8/28 19:53
 */
@Getter
@AllArgsConstructor
public enum PayResultStatusEnum {
    
    PROCESS(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    CANCEL(4, "取消"),
    REFUNDING(5, "退款中"),
    REFUND_SUCCESS(6, "退款成功"),
    ;

    private final Integer status;

    private final String desc;

    public static PayResultStatusEnum getByPayStatus(Integer payStatus) {
        PayStatusEnum statusEnum = PayStatusEnum.getByCode(payStatus);
        switch (statusEnum) {
            case ORDER_FAIL:
            case PAY_FAIL:
                return PayResultStatusEnum.FAIL;
            case PAY_SUCCESS:
                return PayResultStatusEnum.SUCCESS;
            case PAY_REVERSED:
                return PayResultStatusEnum.CANCEL;
            case REFUND_SUCCESS:
                return PayResultStatusEnum.REFUND_SUCCESS;
            case REFUNDING:
            case REFUND_FAIL:
                return PayResultStatusEnum.REFUNDING;
            default:
                return PayResultStatusEnum.PROCESS;
        }
    }
}
