package cn.com.duiba.quanyi.center.api.remoteservice.deposit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.deposit.PaymentInfoDepositInvoiceRefDto;
import cn.com.duiba.quanyi.center.api.param.deposit.PaymentInfoDepositInvoiceRefSearchParam;

import java.util.List;

/**
 * 保证金外部发票关联表远程服务
 * @author xuzhigang
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemotePaymentInfoDepositInvoiceRefService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 关联信息
     */
    PaymentInfoDepositInvoiceRefDto selectById(Long id);

    /**
     * 根据保证金id查询
     * @param paymentInfoId 保证金id
     * @return 关联信息列表
     */
    List<PaymentInfoDepositInvoiceRefDto> selectByPaymentInfoId(Long paymentInfoId);

    /**
     * 根据外部发票id查询
     * @param invoiceExternalId 外部发票id
     * @return 关联信息列表
     */
    List<PaymentInfoDepositInvoiceRefDto> selectByInvoiceExternalId(Long invoiceExternalId);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 关联信息列表
     */
    List<PaymentInfoDepositInvoiceRefDto> selectPage(PaymentInfoDepositInvoiceRefSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    long selectCount(PaymentInfoDepositInvoiceRefSearchParam param);

    /**
     * 保存或更新
     * @param dto 关联信息
     * @return 主键
     */
    Long saveOrUpdate(PaymentInfoDepositInvoiceRefDto dto);

    /**
     * 更新
     * @param dto 关联信息
     * @return 影响行数
     */
    int update(PaymentInfoDepositInvoiceRefDto dto);

    /**
     * 删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
