package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 上传任务状态
 * @author lizhi
 * @date 2023/3/29 2:09 PM
 */
@Getter
@AllArgsConstructor
public enum UploadTaskStatusEnum {
    // 0-初始化 1-上传中 2-上传失败(系统报错) 3-上传完成
    NIT(0, "初始化"),
    IMPORTING(1, "导入中"),
    IMPORT_FAILURE(2, "导入失败"),
    IMPORT_SUCCESS(3, "导入完成"),
    MQ_PROCESSING(4, "mq处理中"),
    DELETING(5, "删除中"),
    DELETE_FAILURE(6, "删除异常"),
    DELETE_SUCCESS(7, "删除成功"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, UploadTaskStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(UploadTaskStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据状态值获取枚举
     * @param status 状态值
     * @return 枚举
     */
    public static UploadTaskStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
